/* $Id: event.c,v 1.8 1998/12/18 00:42:37 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Keith Bayern */

/***************************************************************************

This program shows use of the interrupts

See minimum.c for build information

Be sure to compile this as a console application as there are printfs in here

***************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "hpe1432.h"

/* global vars */
static volatile ViInt32 loopflag;
static ViSession	session;
static ViInt32		gid;
static char		st[100];

#define BLOCK_SIZE 16

/******************
*
* This is the user function that will be called when the interrupt occurs
*
*
******************/

void mycbfunc(ViInt32 a,ViInt32 b)
{
ViInt32		i;
ViStatus	vierr;
ViReal64	data[BLOCK_SIZE];
ViInt32		actualCount;
ViInt32		reason;


    vierr=hpe1432_getInterruptReason(session,1,&reason);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(EXIT_FAILURE);
    }

printf("in mycbfunc  a=%d  b=%d  reason=%d\n",a,b,reason);

    if(reason&HPE1432_IRQ_BLOCK_READY)
    {
        /* read the data */
        vierr=hpe1432_readFloat64Data(session,gid,
                                      HPE1432_TIME_DATA,
                                      data,
                                      BLOCK_SIZE,
                                      &actualCount,
                                      HPE1432_WAIT_FLAG);
        if(vierr)
        {
            hpe1432_error_message(session,vierr,st);
            printf("error %d = %s\n",vierr,st);
            exit(EXIT_FAILURE);
        }

        /* print the data */
	    printf("--- loop %d ----\n",loopflag);
        for(i=0;i<5;i++)
		    printf("%lf\n",data[i]);


        loopflag--;
    }


    /* this part could be tricky for multi board setups but the good */
    /* news is that it is OK to reenable interrupts for boards not */
    /* interrupting */
    if (loopflag > 0)
    {
	vierr=hpe1432_reenableInterrupt(session,1);
	if(vierr)
	{
	    hpe1432_error_message(session,vierr,st);
	    printf("error %d = %s\n",vierr,st);
	    exit(EXIT_FAILURE);
	}
    }
  

    return;    
}






int
main(void)
{
ViInt32		channels[10];
ViStatus	vierr;



    /* initialize instrument  This code ASSUMES hpe1432 at address 8 */
    vierr=hpe1432_init("VXI0::8::INSTR",0,1,&session);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);	    
        exit(EXIT_FAILURE);
    }

    /* make an array of input channel numbers (only one in this simple demo) */
    channels[0]=1;

    vierr=hpe1432_createChannelGroup(session,1,channels,&gid);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(EXIT_FAILURE);
    }

    /* set the fifo blocksize */
    vierr=hpe1432_setBlocksize(session,gid,BLOCK_SIZE);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(EXIT_FAILURE);
    }

    /* set up for call back when data ready */
    vierr=hpe1432_callbackInstall(session,1,mycbfunc,0);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(EXIT_FAILURE);
    }

    /* set up E1432 mask */
    vierr=hpe1432_setInterruptMask(session,1,HPE1432_IRQ_BLOCK_READY);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(EXIT_FAILURE);
    }

    /* I found that line 7 worked, you may want to read the output */
    /* of your resource manager when it runs at startup for clues */
    vierr=hpe1432_setInterruptPriority(session,1,7);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(EXIT_FAILURE);
    }

printf("This demo may need to be modified and recompiled before running.\n");
printf("If you don't see data within 1 second, you are locked up and need to abort.\n\n");

    /* get some data coming */
    vierr=hpe1432_initMeasure(session,gid);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(EXIT_FAILURE);
    }
 
    loopflag=4;
    while(loopflag>0);  /* WAIT HERE until loop flag is zero */

	/* end gracefully */
    vierr=hpe1432_close(session); 
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(EXIT_FAILURE);
    }

    return EXIT_SUCCESS;
}

